//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify GENP CMP Response and save CLR
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_GENP_FILE "cmp_genp.bin"
#define CMP_CRL_FILE  "cmp_genp.crl"
#define CMP_RA_CERT "cmp_ra.cer"
//------------------------------------------------------------------------------
unsigned char Cert[8196];
unsigned char *Genp;
unsigned char *CRL;
//------------------------------------------------------------------------------
//    CMP-   CMP/GENM
// :
// 1.   
// 2.    CMP-   CMP/GENP,    
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey;
 DWORD rv,dw,len,type,sz;
 char transID[65];

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   
 if (getFileLen(CMP_GENP_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 Genp=(unsigned char*) calloc(sz+1,sizeof(unsigned char));
 if (readFile  (CMP_GENP_FILE,Genp,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //   
 if (!CPImportKey(hProv,Genp,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //   
 len=sizeof(type);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TYPE,(BYTE*)&type,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TYPE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //      
 if (type==PKI_CMP_ERROR) {
   len=sizeof(dw);
   if (!CPGetKeyParam(hProv,hKey,KP_CMP_STATUS,(BYTE*)&dw,&len,0)) {
     printf("CPGetKeyParam KP_CMP_STATUS Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   printf("PKI_CMP_ERROR, STATUS: %d (%s)\n",dw,code2status(dw));
   dw=0xFF;
   len=sizeof(dw);
   if (!CPGetKeyParam(hProv,hKey,KP_CMP_FAIL,(BYTE*)&dw,&len,0)) {
     printf("CPGetKeyParam KP_CMP_FAIL Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   if (dw!=0xFF) printf("FAIL: %d (%s)\n",dw,code2fail(dw));
   return 1;
 }
 //     
 if (type!=PKI_CMP_GENP && type!=PKI_CMP_GENM) {
   printf("Unknown CMP TYPE: %d\n",type);
   return 1;
 }
 //  transactionID
 len=sizeof(transID);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,(BYTE*)transID,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 printf("transactionID = %s\n",transID);
 //  OID   CRL
 if (!CPSetKeyParam(hProv,hKey,KP_CMP_GEN_OID,(BYTE*)CMP_GENERAL_CRL,0)) {
   printf("CPSetKeyParam KP_CMP_EXP_KEY Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 CRL=(unsigned char*) calloc(sz+1,sizeof(unsigned char));
 len=sz;
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_GEN_VAL,CRL,&len,0)) {
   printf("CPGetKeyParam KP_CMP_GEN_VAL Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //
 //   (.  )
 //
 //  
 writeFile(CMP_CRL_FILE,CRL,len);
 //     
 len=sizeof(Cert);
 if (!CPGetKeyParam(hProv,hKey,KP_CERTIFICATE,Cert,&len,0)) {
   rv=GetLastErrorCSP(hProv);
   if (rv!=NTE_NOT_FOUND) {
     printf("CPGetKeyParam KP_CERTIFICATE Error: %0X\n",rv);
     return 1;
   }
   //   ,     
   len=sizeof(Cert);
   if (!CPGetKeyParam(hProv,hKey,KP_KEY_SN,Cert,&len,0)) {
     printf("CPGetKeyParam KP_KEY_SN Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   writeFile("sn.bin",Cert,len);
   //    ,   
   //  ,    
   if (getFileLen(CMP_RA_CERT,&len))   {printf("getFileLen error\r\n"); return 1;}
   if (readFile(CMP_RA_CERT,Cert,len)) {printf("readFile error\r\n");   return 1;}
 }
 else {
   if (!CPVerifySignature(hProv,0,Cert,(DWORD)len,0,NULL,CRYPT_OBJECT_CRT)) {
     printf("CPVerifySignature (CRYPT_OBJECT_CRT) error\r\n");
     return 1;
   }
 }
 //
 //   (.  )
 //
 CPDestroyKey(hProv,hKey);
 //   
 if (!CPImportKey(hProv,Cert,len,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 if (!CPVerifySignature(hProv,0,Genp,sz,hKey,NULL,CRYPT_OBJECT_CMP)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 CPDestroyKey(hProv,hKey);
 free(Genp);
 free(CRL);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
